<?php

if ( !defined( 'ABSPATH' ) ) {
	exit();
}

require_once( CRYPTONIQ_DIR_PATH . 'admin/metabox.php');

function cryptoniq_load_redux_panel() {
	if ( !class_exists( 'ReduxFramework' ) && file_exists( CRYPTONIQ_DIR_PATH . 'ReduxCore/redux-core/framework.php' ) ) {
		require_once CRYPTONIQ_DIR_PATH . 'ReduxCore/redux-core/framework.php';
	}

	if ( class_exists( 'ReduxFramework' ) && method_exists( 'Redux', 'get_option' )  ) {
		require_once CRYPTONIQ_DIR_PATH . 'admin/options.php';
	}
}
add_action( 'init', 'cryptoniq_load_redux_panel', 1 );

function cryptoniq_admin_styles() {
    wp_enqueue_style(
        'my-admin-style', 
        plugins_url('/assets/css/cryptoniq.css', __FILE__), 
        array(), 
        CRYPTONIQ_VER
    );
	
    // Only load on admin pages
    wp_enqueue_script(
        'my-admin-script',
        plugins_url('/assets/js/cryptoniq.js', __FILE__),
        array(), 
        CRYPTONIQ_VER,
        true
    );
}
add_action('admin_enqueue_scripts', 'cryptoniq_admin_styles');