<?php
/**
 * Plugin Name: Cryptoniq PRO
 * Plugin URI: https://cryptoniq.io
 * Description: Pay with cryptocurrencies.
 * Version: 1.2.3
 * Author: DivEngine
 * Author URI: https://t.me/div_engine
 * Text Domain: cryptoniq
 */

if ( ! defined( 'ABSPATH' ) ) exit();

// === Define constants ===
if ( ! defined( 'CRYPTONIQ_VER' ) ) define( 'CRYPTONIQ_VER', '1.2.3' );
if ( ! defined( 'CRYPTONIQ_DIR_URL' ) ) define( 'CRYPTONIQ_DIR_URL', plugin_dir_url( __FILE__ ) );
if ( ! defined( 'CRYPTONIQ_DIR_PATH' ) ) define( 'CRYPTONIQ_DIR_PATH', plugin_dir_path( __FILE__ ) );
if ( ! defined( 'CRYPTONIQ_PAY_ID' ) ) define( 'CRYPTONIQ_PAY_ID', 'cryptoniq' );
if ( ! defined( 'CRYPTONIQ_OPTION' ) ) define( 'CRYPTONIQ_OPTION', 'cryptoniq_option' );
if ( ! defined( 'CRYPTONIQ_API_URL' ) ) define( 'CRYPTONIQ_API_URL', 'https://api.cryptoniq.io/' );


// === Main Plugin Class ===
class Cryptoniq_Engine {
	private $files = array(
		'admin/index.php',
		'gateway.php',
		'functions.php',
		'ajax.php',
		'prices.php',
		'prefixes.php'
	);

	function __construct() {
		// Delay localization until WordPress is ready
		add_action( 'init', array( $this, 'load_textdomain' ) );

		// Continue setup
		$this->include_files();
		add_action( 'init', array( $this, 'register_assets' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_assets' ), 9999 );
	}

	private function include_files() {
		foreach ( $this->files as $file ) {
			require_once( CRYPTONIQ_DIR_PATH . $file );
		}
	}

	public function load_textdomain() {
		load_plugin_textdomain( 'cryptoniq', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	}

	public function register_assets() {
		wp_register_style( 'cryptoniq-libs-ionicons',
			CRYPTONIQ_DIR_URL . 'assets/libs/ionicons/css/ionicons.css',
			array(), CRYPTONIQ_VER );

		wp_register_style( 'cryptoniq-engine',
			CRYPTONIQ_DIR_URL . 'assets/css/cryptoniq.engine.css',
			array(), CRYPTONIQ_VER );

		wp_register_script( 'cryptoniq-libs',
			CRYPTONIQ_DIR_URL . 'assets/js/cryptoniq.libs.js',
			array( 'jquery' ), CRYPTONIQ_VER, false );

		wp_register_script( 'cryptoniq-engine',
			CRYPTONIQ_DIR_URL . 'assets/js/cryptoniq.engine.js',
			array( 'jquery' ), CRYPTONIQ_VER, false );

		wp_localize_script( 'cryptoniq-engine', 'cryptoniq_paybox_ajax_data', array(
			'url'   => admin_url( 'admin-ajax.php' ),
			'nonce' => wp_create_nonce( 'cryptoniq_front_ajax_nonce' )
		));
	}

	public function enqueue_assets() {
		wp_enqueue_style( 'cryptoniq-libs-ionicons' );
		wp_enqueue_style( 'cryptoniq-engine' );
		wp_enqueue_script( 'cryptoniq-libs' );
		wp_enqueue_script( 'cryptoniq-engine' );
	}
}
new Cryptoniq_Engine();

// === CRON: Update Prices ===
function cryptoniq_cron_update_prices( $schedules ) {
	$schedules['cryptoniq_updater_30m'] = array(
		'interval' => 60 * 60,
		'display'  => esc_html__( 'Every 30 Minutes', 'cryptoniq' )
	);
	return $schedules;
}
add_filter( 'cron_schedules', 'cryptoniq_cron_update_prices' );

function cryptoniq_price_options_updater() {
	$all_options = wp_load_alloptions();

	if ( ! is_array( cryptoniq_get_currency_prices() ) || ! array_key_exists( 'EUR', cryptoniq_get_currency_prices() ) ) {
		return false;
	}

	if ( ! array_key_exists( 'cryptoniq_currency_prices', $all_options ) ) {
		add_option( 'cryptoniq_currency_prices', cryptoniq_get_currency_prices(), '', 'yes' );
	} else {
		update_option( 'cryptoniq_currency_prices', cryptoniq_get_currency_prices(), 'yes' );
	}

	if ( ! is_array( cryptoniq_get_coin_prices() ) || ! array_key_exists( 'ETH_ARB', cryptoniq_get_coin_prices() ) ) {
		return false;
	}

	if ( ! array_key_exists( 'cryptoniq_coin_prices', $all_options ) ) {
		add_option( 'cryptoniq_coin_prices', cryptoniq_get_coin_prices(), '', 'yes' );
	} else {
		update_option( 'cryptoniq_coin_prices', cryptoniq_get_coin_prices(), 'yes' );
	}
}
add_action( 'cryptoniq_cron_update_prices', 'cryptoniq_price_options_updater' );

// === Option Check ===
function cryptoniq_check_options() {
	$prices = get_option( 'cryptoniq_coin_prices' );
	$currencies = get_option( 'cryptoniq_currency_prices' );

	if ( ! is_array( $prices ) || ! array_key_exists( 'ETH_ARB', $prices ) ||
	     ! is_array( $currencies ) || ! array_key_exists( 'EUR', $currencies ) ) {
		cryptoniq_price_options_updater();
	}
}
add_action( 'init', 'cryptoniq_check_options', 5 );

// === Cron Activation / Deactivation ===
function cryptoniq_cron_activation() {
	if ( ! wp_next_scheduled( 'cryptoniq_cron_update_prices' ) ) {
		wp_schedule_event( time(), 'cryptoniq_updater_30m', 'cryptoniq_cron_update_prices' );
	}
	
	// Immediately fetch prices on activation if not present
	$prices = get_option( 'cryptoniq_coin_prices' );
	$currencies = get_option( 'cryptoniq_currency_prices' );

	if ( ! is_array( $prices ) || ! array_key_exists( 'ETH_ARB', $prices ) ||
	     ! is_array( $currencies ) || ! array_key_exists( 'EUR', $currencies ) ) {
		cryptoniq_price_options_updater();
	}
}
register_activation_hook( __FILE__, 'cryptoniq_cron_activation' );

function cryptoniq_cron_deactivation() {
	wp_clear_scheduled_hook( 'cryptoniq_cron_update_prices' );
}
register_deactivation_hook( __FILE__, 'cryptoniq_cron_deactivation' );
