<?php

if ( !defined( 'ABSPATH' ) ) {
	exit();
}

if ( ! $order || ! is_a( $order, 'WC_Order' ) ) {
    return;
}

$license_key = cryptoniq_get_option('license_key');
$order_id = $order->get_id();
$timestamp = $order->get_meta( 'cryptoniq_time_start' );
$wallet = $order->get_meta( 'cryptoniq_coin_wallet' );
$amount = $order->get_meta( 'cryptoniq_coin_amount' );
$coin = $order->get_meta( 'cryptoniq_coin_ticker' );
$coin_name = cryptoniq_get_coin_data($coin, 'name');

if (!array_key_exists($coin, cryptoniq_get_payment_coins()) || !$coin) {
	$message = esc_html( 'No payment coin', 'cryptoniq' );
	return wc_print_notice( $message, 'error' );
}

if (!$wallet) {
	$message = esc_html( 'No wallet for', 'cryptoniq' );
	return wc_print_notice( $message . ' ' . $coin_name, 'error' );
}

if (!$amount) {
	$message = esc_html( 'Invalid amount', 'cryptoniq' );
	return wc_print_notice( $message, 'error' );
}

if ( $order->get_status() == 'failed' ) {
	$message = esc_html( 'Payment failed', 'cryptoniq' );
	return wc_print_notice( $message, 'error' );
}

if ( !$license_key ) {
	$message = esc_html( 'License is not activated', 'cryptoniq' );
	return wc_print_notice( $message, 'error' );	
}

?>

<div class="cryptoniq-paybox-layer cryptoniq-paybox-layer-mask cryptoniq-clearfix">
	<div id="cryptoniq-paybox" class="cryptoniq-paybox cryptoniq-border-box cryptoniq-clearfix">
		<div class="cryptoniq-paybox-topbar">
			<div class="cryptoniq-paybox-topbar-wrapper cryptoniq-clearfix">
				<div class="cryptoniq-paybox-heading"><span class="cryptoniq-paybox-heading-pre"><?php esc_html_e( 'Payment', 'cryptoniq' ); ?></span>: <?php echo $coin_name; ?></div>
			</div>
		</div>
		<div class="cryptoniq-paybox-container">
			<div class="cryptoniq-paybox-section-wrapper">
				<div class="cryptoniq-paybox-section-content">
					<div class="cryptoniq-paybox-data">
						<div class="cryptoniq-paybox-section-title cryptoniq-clearfix">
							<div class="cryptoniq-paybox-section-title-left cryptoniq-paybox-section-title-mask"><?php esc_html_e( 'How to pay', 'cryptoniq' ); ?></div>
							<div id="cryptoniq-paybox-tooltip-button" class="cryptoniq-paybox-section-title-right"><i></i></div>
						</div>
						<div class="cryptoniq-paybox-order-details">
							<ul>
								<li>
									<div class="cryptoniq-paybox-order-title"><?php esc_html_e( 'Please, send', 'cryptoniq' ); ?> <i id="cryptoniq-paybox-address-copy" data-clipboard-target="#cryptoniq-paybox-amount"></i></div>
									<div class="cryptoniq-paybox-order-text">
										<span class="cryptoniq-paybox-order-text-mask"><?php echo $coin; ?>: <span id="cryptoniq-paybox-amount"><?php echo $amount; ?></span></span><span class="cryptoniq-paybox-order-price-fiat"><?php echo wp_kses_post( $order->get_formatted_order_total() ); ?></span>
									</div>
								</li>
								<li>
									<div class="cryptoniq-paybox-order-title"><?php esc_html_e( 'To this address', 'cryptoniq' ); ?> <i id="cryptoniq-paybox-address-copy" data-clipboard-target="#cryptoniq-paybox-address"></i></div>
									<div class="cryptoniq-paybox-order-text cryptoniq-paybox-order-text-address">
										<span id="cryptoniq-paybox-address" class="cryptoniq-paybox-order-text-mask"><?php echo $wallet; ?></span>
									</div>
								</li>
								<li>
									<div class="cryptoniq-paybox-order-title"><?php esc_html_e( 'Scan QR code', 'cryptoniq' ); ?></div>
									<div id="cryptoniq-paybox-qrcode" class="cryptoniq-paybox-order-text cryptoniq-paybox-qrcode"></div>
								</li>
							</ul>
						</div>
						<div class="cryptoniq-paybox-instructions">
							<div class="cryptoniq-paybox-instructions-container">
								<div class="cryptoniq-paybox-instructions-topbar cryptoniq-clearfix">
									<div class="cryptoniq-paybox-instructions-title"><?php esc_html_e( 'Instruction', 'cryptoniq' ); ?></div>
									<div id="cryptoniq-paybox-instructions-close"><i></i></div>
								</div>
								<div class="cryptoniq-paybox-instructions-content">
									<p><?php esc_html_e( 'To make a payment, send required amount of coins to mentioned address. It must be as one transaction (not included the fees).', 'cryptoniq' ); ?></p>
									<p><?php esc_html_e( 'System will give you 3 hours, in which time the transaction must be completed. So if you haven\'t sent the coins before clicking the check button, you still can. But note that if the coins are not received within a given time, order will be automatically cancelled and payment will be failed.', 'cryptoniq' ); ?></p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="cryptoniq-paybox-bottombar">
			<div class="cryptoniq-paybox-bottombar-wrapper">
				<div id="cryptoniq-paybox-tx-bar" class="cryptoniq-paybox-tx-form" data-id="<?php echo $order_id; ?>" data-coin="<?php echo $coin; ?>" data-time="<?php echo $timestamp; ?>">
					<div id="cryptoniq-paybox-tx-checker" class="cryptoniq-paybox-tx-check-bar">
						<div class="cryptoniq-paybox-tx-content">
							<div class="cryptoniq-paybox-tx-info">
								<div class="cryptoniq-paybox-line-st-time">
									<span id="cryptoniq-paybox-loader" class="cryptoniq-paybox-loader"></span><span id="cryptoniq-paybox-alert" class="cryptoniq-paybox-alert"><?php esc_html_e( 'Checking...', 'cryptoniq' ); ?></span><span class="cryptoniq-paybox-tx-counter-text"><?php esc_html_e( 'Time:', 'cryptoniq' ); ?></span> <span id="cryptoniq-paybox-tx-counter">00:00:00</span>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>