<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Enable filters if price display is enabled
if ( cryptoniq_get_option( 'price_coin_show' ) ) {
	add_filter( 'woocommerce_get_price_html', 'cryptoniq_item_price_filter', 10, 2 );

	// Cart page prices
	add_filter( 'woocommerce_cart_item_price', 'cryptoniq_cart_item_price_filter', 10, 3 );
	add_filter( 'woocommerce_cart_item_subtotal', 'cryptoniq_cart_item_subtotal_filter', 10, 3 );
	add_filter( 'woocommerce_cart_subtotal', 'cryptoniq_cart_subtotal_filter', 10, 3 );
	add_filter( 'woocommerce_cart_total', 'cryptoniq_cart_total_filter', 10, 1 );
}

// Format crypto price
function cryptoniq_format_crypto_price( $amount ) {
	$coin    = cryptoniq_get_option( 'price_coin_ticker' ) ?: 'BTC';
	$type    = cryptoniq_get_option( 'price_coin_sign' ) ?: 'text';
	$divider = cryptoniq_get_option( 'price_coin_divider' ) ?: '/';

	$symbol = $type === 'icon'
		? '<i class="cryptoniq-product-list-icon cryptoniq-product-list-icon-' . strtolower( $coin ) . '"></i>'
		: '<span class="cryptoniq-coin-tag">' . esc_html( $coin ) . '</span>';

	$crypto = cryptoniq_get_price( $coin, $amount );

	return '<span class="cryptoniq-price-crypto"> ' . esc_html( $divider ) . ' ' . $symbol . $crypto . '</span>';
}

// Product page price
function cryptoniq_item_price_filter( $price_html, $product ) {
	$coin    = cryptoniq_get_option( 'price_coin_ticker' ) ?: 'BTC';
	$divider = cryptoniq_get_option( 'price_coin_divider' ) ?: '/';
	$type    = cryptoniq_get_option( 'price_coin_sign' ) ?: 'text';

	$symbol = $type === 'icon'
		? '<i class="cryptoniq-product-list-icon cryptoniq-product-list-icon-' . strtolower( $coin ) . '"></i>'
		: '<span class="cryptoniq-coin-tag">' . esc_html( $coin ) . '</span>';

	$get_crypto = function( $amount ) use ( $symbol, $coin ) {
		return '<span class="cryptoniq-price-line">' . $symbol . cryptoniq_get_price( $coin, $amount ) . '</span>';
	};

	if ( $product->is_type( 'grouped' ) ) {
		$children = $product->get_children();
		$prices = [];

		foreach ( $children as $child_id ) {
			$child = wc_get_product( $child_id );
			if ( $child && $child->get_price() > 0 ) {
				$prices[] = $child->get_price();
			}
		}

		if ( ! empty( $prices ) ) {
			$min = min( $prices );
			$max = max( $prices );

			$crypto = $min !== $max
				? $get_crypto( $min ) . ' – ' . $get_crypto( $max )
				: $get_crypto( $min );
		} else {
			$crypto = '';
		}
	} elseif ( $product->is_type( 'variable' ) ) {
		$min = $product->get_variation_price( 'min', true );
		$max = $product->get_variation_price( 'max', true );
		$crypto = $min !== $max ? $get_crypto( $min ) . ' – ' . $get_crypto( $max ) : $get_crypto( $min );
	} elseif ( $product->is_on_sale() ) {
		$crypto = '<del>' . $get_crypto( $product->get_regular_price() ) . '</del> ';
		$crypto .= '<ins>' . $get_crypto( $product->get_sale_price() ) . '</ins>';
	} else {
		$crypto = $get_crypto( $product->get_price() );
	}

	return '<span class="cryptoniq-price-wrapper">' . $price_html . ' <span class="cryptoniq-product-divider">' . esc_html( $divider ) . '</span>' . $crypto . '</span>';
}

// Cart: unit price
function cryptoniq_cart_item_price_filter( $price, $cart_item, $cart_item_key ) {
	$product = $cart_item['data'];
	return '<span class="cryptoniq-price-wrapper">' . $price . cryptoniq_format_crypto_price( $product->get_price() ) . '</span>';
}

// Cart: item subtotal
function cryptoniq_cart_item_subtotal_filter( $subtotal, $cart_item, $cart_item_key ) {
	$total = $cart_item['line_total'];
	return '<span class="cryptoniq-price-wrapper">' . $subtotal . cryptoniq_format_crypto_price( $total ) . '</span>';
}

// Cart: subtotal (fixes live updates)
function cryptoniq_cart_subtotal_filter( $price, $cart = null ) {
	$total = WC()->cart ? WC()->cart->subtotal : 0;
	return '<span class="cryptoniq-price-wrapper">' . $price . cryptoniq_format_crypto_price( $total ) . '</span>';
}

// Cart: total
function cryptoniq_cart_total_filter( $price ) {
	$total = WC()->cart ? WC()->cart->total : 0;
	return '<span class="cryptoniq-price-wrapper">' . $price . cryptoniq_format_crypto_price( $total ) . '</span>';
}
