<?php

if ( !defined( 'ABSPATH' ) ) {
	exit();
}

function cryptoniq_get_currency_prices() {
    $url = CRYPTONIQ_API_URL . 'currencies';
    $license_key = cryptoniq_get_option( 'license_key' );

    if ( empty( $license_key ) ) {
        return false;
    }

    $request = wp_remote_get( $url, array(
        'headers' => array(
            'X-Cryptoniq-License' => $license_key,
        ),
        'timeout' => 15,
    ) );

    if ( is_wp_error( $request ) ) {
        return false;
    }

    $code = wp_remote_retrieve_response_code( $request );
    $body = wp_remote_retrieve_body( $request );
    $coinslist = json_decode( $body, true );

    if ( $code !== 200 || !is_array( $coinslist ) || !isset( $coinslist['EUR'] ) ) {
        return false;
    }

    return $coinslist;
}

function cryptoniq_get_coin_prices() {
    $url = CRYPTONIQ_API_URL . 'prices';
    $license_key = cryptoniq_get_option( 'license_key' );

    if ( empty( $license_key ) ) {
        return false;
    }

    $request = wp_remote_get( $url, array(
        'headers' => array(
            'X-Cryptoniq-License' => $license_key,
        ),
        'timeout' => 15,
    ) );

    if ( is_wp_error( $request ) ) {
        return false;
    }

    $code = wp_remote_retrieve_response_code( $request );
    $body = wp_remote_retrieve_body( $request );
    $pricelist = json_decode( $body, true );

    if ( $code !== 200 || !is_array( $pricelist ) || !isset( $pricelist['BTC'] ) ) {
        return false;
    }

    return $pricelist;
}
	
function cryptoniq_get_price( $coin = 'BTC', $amount = '', $currency = '', $random = false, $mask = true ) {
	if (!$mask) {
		$pws = $pwe = '';
	} else {
		$pws = '<span class="cryptoniq-price-mask">';
		$pwe = '</span>';		
	}
	
	if ( ! isset( $amount ) || ! is_numeric( $amount ) ) {
		return $pws . '0.00000000' . $pwe;
	}

	$base_currency   = get_woocommerce_currency();
	$currency_prices = get_option( 'cryptoniq_currency_prices' );
	$coin_prices     = get_option( 'cryptoniq_coin_prices' );

	// Convert to USD if base currency is not USD
	if ( $currency && isset( $currency_prices[ $currency ] ) ) {
		$amount = $amount / $currency_prices[ $currency ];
	} elseif ( $base_currency !== 'USD' && $base_currency !== 'BTC' && isset( $currency_prices[ $base_currency ] ) ) {
		$amount = $amount / $currency_prices[ $base_currency ];
	}

	// Check if stablecoin
	$is_stable = strpos( $coin, 'USDT' ) !== false || strpos( $coin, 'USDC' ) !== false;

	// Conversion to coin
	if ( $is_stable ) {
		$price = $amount;
	} elseif ( isset( $coin_prices[ $coin ] ) && $coin_prices[ $coin ] > 0 ) {
		if ( $base_currency === 'BTC' ) {
			$price = $amount;
		} else {
			$price = $amount / $coin_prices[ $coin ];
		}
	} else {
		return $pws . '0.00000000' . $pwe; // fallback if no rate
	}

	// Add a slight randomizer for realism (optional)
	$round_length = 100000000;
	if ( $coin === 'TRX' || $is_stable ) {
		$round_length = 1000000;
	} elseif ( $coin === 'SOL' ) {
		$round_length = 1000000000;
	}
	
	$extra_random_number = $random ? rand( 100, 999 ) / $round_length : 0;
	if ( $coin === 'BTC' && $random ) {
		$extra_random_number = rand( 10, 99 ) / $round_length;
	}

	$coins_num = $price + $extra_random_number;

	// Format based on coin
	if ( $coin === 'TRX' || $is_stable ) {
		$coin_format = number_format( $coins_num, 6, '.', '' );
	} elseif ( $coin === 'SOL' ) {
		$coin_format = number_format( $coins_num, 9, '.', '' );
	} else {
		$coin_format = number_format( $coins_num, 8, '.', '' );
	}
	
	return $pws . esc_html( $coin_format ). $pwe;
}